#!/usr/bin/env python
#encoding: utf-8

"""Constants and functions for the effect of positions in the Blob Battle.

The POSITION:CHANGE_EFFECT maps positions and counter positions and and modifiers on the attack roll. 

It's a dictionary which holds first the attack position, inside this the defend position and below that the modifier value. 

It is used to calculate the effect of changing teh position, as well as teh effect of attack position prediction by the defender (if the defender correctly guesses the attack position of his enemy, he gets a bonus, if he misses by a bit, he no mods, and if he completely misses, he gets a bad malus 8since he has to change the position from the expected to the real attack position).
"""

# The effects of positions and the relevant counter-positions on the attack-roll. 
# The effects get added to the roll of the defender and substracted from the role of the attacker. 

# The effect is the difficulty of switching from the first position to the second. 

#: A dict of positions and counter positions. Structure: position:counter_position:effect
POSITION_CHANGE_EFFECT = {
1:  
    {  
        1: 1,  
        2: 1,  
        3: 0, 
        4: 1, 
        5: 0, 
        6: -1, 
        7: 0, 
        8: -1, 
        9: -1
    },  

2: 
    { 
        1: 1,  
        2: 1,  
        3: 1, 
        4: 0, 
        5: 0, 
        6: 0, 
        7: -1, 
        8: -1, 
        9: -1  
    },  

3: 
    { 
        1: 0,  
        2: 1,  
        3: 1, 
        4: -1, 
        5: 0, 
        6: 1, 
        7: -1, 
        8: -1, 
        9: 0  
    },  

4: 
    { 
        1: 1,  
        2: 0,  
        3: -1, 
        4: 1, 
        5: 0, 
        6: -1, 
        7: 1, 
        8: 0, 
        9: -1  
    },  

5: # The change from 5 explained. 5 means to try to pierce the head. so 
    { 
        1: -1,  # switching down left is hard
        2: 1,  # piercing the bowels is easy
        3: -1, # switching down right is hard
        4: 0,  # switching to left (or defending from left) is default
        5: 1, # Piercing the head again (or defending correctly chosen) is easy. 
        6: 0,  # switching to right (or defending from right) is default
        7: 0, # switching up left is default
        8: 0, # As is switching to an attack from above
        9: 0  # or to up right
    },  

6: 
    { 
        1: -1,  
        2: 0,  
        3: 1, 
        4: -1, 
        5: 0, 
        6: 1, 
        7: -1, 
        8: 0, 
        9: 1  
    },  

7: 
    { 
        1: 0,  
        2: -1,  
        3: -1, 
        4: 1, 
        5: 0, 
        6: -1, 
        7: 1, 
        8: 1, 
        9: 0  
    },  

8: 
    { 
        1: -1,  
        2: -1,  
        3: -1, 
        4: 0, 
        5: 0, 
        6: 0, 
        7: 1, 
        8: 1, 
        9: 1  
    },  

9: 
    { 
        1: -1,  
        2: -1,  
        3: 0, 
        4: -1, 
        5: 0, 
        6: 1, 
        7: 0, 
        8: 1, 
        9: 1  
    },  

}
