#!/usr/bin/env python
# encoding: utf-8

###########################################################################
#    Copyright (C) 2007 by Achim Zien und Arne Babenhauserheide                                      
#    <arne_bab@web.de>                                                             
#
# Copyright: See COPYING file that comes with this distribution
#
###########################################################################

"""Calculate a fight between two chars (given as list) according to the EWS One Roll Fight system."""

verbose = False

#### imports ####

#### /imports ####

#### Fonctions ####

def fight(chars):
    """Calculate a fight between two individuals with the One Roll fight system
    
    Plans: 
    - Add Fatigue, since each single fight drains each fighter, so people can't fight forever with their full strength, Fatigue is an attribute. From this we determine a fatigue value (2*Fatigue). If this falls to 1/2, the fighter gets 1 point malus. If it falls to 1/6th, the fighter gets 3 points malus. If it falls to 0, the fighter gets 6 points malus ans has to check, if he stays standing. The he has to check if he stays standing again each time, the fatigue value drops below a multiple of the Fatigue attribute below zero. At fatigue value = -4x Fatigue attribute, the fighter falls unconscious. 
    """
    
    # attack rolls
    reslist = []                        # initialize empty, else no values will be used (actual values at end of list)
    for i in chars:
        reslist.append(i.do_attack())   # changed from "i.attack", do attack performs attack roll in Char
    #print reslist # old bugfixing code? 
    res = reslist[0]-reslist[1]
    
    # verbose code
    if verbose:
        print 'Result:', chars[0].name + ':', reslist[0] , '-', chars[1].name + ':', reslist[1]
    if verbose:
            print 'Result in numbers:', res
            
    # damage, formatting: (tp, wounds, heavy wounds)
    # style-formatting:  (skill mod, (win own damage[base,stepsize]), (loose own damage[base,stepsize]), special pars
    if res == 0:
        chars[0].damage(0,3,0)
        chars[1].damage(0,3,0)
        if verbose: 
            print "Both are still standing but wounded (or dead)."
    else:
        if res > 0:
            winnerc = chars[0]
            loserc = chars[1]
        else:
            winnerc = chars[1]
            loserc = chars[0]
        res = abs(res)
        
        # escape style results
        if winnerc.style[3] == 'escape':
            winner = 0
            loser = 0 # The loser gets no damage, because the winner flees. 
            if verbose: 
                print "Winner-Style:", winnerc.style
                print "Loser-Style:", loserc.style
            if verbose: 
                print loser
            winnerc.escape_check()
            if verbose: 
                print winnerc.name, "flees."
        
        # offensive style results
        elif loserc.style[3] == 'dead':
            if verbose: 
                print "Winner-Style:", winnerc.style
                print "Loser-Style:", loserc.style
            winner = max(winnerc.style[1][0]-res/winnerc.style[1][1],0)
            loser = 18 # After 18 wounds, you are definitely dead. Thats 6 times your TP. 
            # there's no coming back to life after that. 
            loserc.active = False
            loserc.alive = False
            if verbose: 
                print loserc.name, "dies."
        
        # other results
        else:
            if verbose: 
                print "Winner-Style:", winnerc.style
                print "Loser-Style:", loserc.style
            winner = max(winnerc.style[1][0]-res/winnerc.style[1][1],0)
            loser = max(loserc.style[2][0]+res/loserc.style[2][1],0)
        if verbose:
            print winnerc.name, "won against", loserc.name
        winnerc.damage(0,winner,0)
        if verbose: 
            print winnerc.name, "takes", winner, "wounds." 
        loserc.damage(0,loser,0)
        if verbose: 
            print loserc.name, "takes", loser, "wounds."
        if winnerc.morale[2] < 6:
            winnerc.morale[2] += 1
            if verbose: 
                print "The morale of", winnerc.name, "rises by 1 to", winnerc.morale[0] + winnerc.morale[2]
        if loserc.active and loserc.alive and winnerc.style[3] != 'escape': #shouldn't loser == 0 in the latter case?
            loserc.queue_up(loser*3) # Wait 3 rounds per wound. - defensive style reduces the wounds of the loser, so it doesn't queue up people for too long.

    

#### /Functions ####

#### Self-Test ####

if __name__ == "__main__": 
    from schlachtfeld.amov import Charakter, Versionsverwaltung
    from schlachtfeld.Char import *
    verbose = true
    chars = [Char() for i in range(2)]
    #for i in range(2):
        #char = Char()
        #chars.append(char)
    print "Characters:\n", chars
    print "\nStarting the fight:"
    fight(chars)
    

#### /Self-Test ####
