#/ust/bin/env python
# encoding: utf-8

"""Ein Experiment mit PyGlet."""


    
# Für den ersten Versuch (Schrift im Fenster) brauchen wir Schrift. 

from pyglet import font

# Und natürlich ein Fenster. 

from pyglet import window
    
# Für den Schwarm Bilder

from pyglet import image

# Dazu brauchen wir etwas, um Dateipfade zu erzeugen

from os import path

# Und wir wollen zufällige Positionen

from random import randint

# Außerdem die möglichkeit zu warten. 

from time import sleep


def hallo_welt():
    # Erstmal ein paar GUI experimente. 
    
    # Wir können PyGlet nutzen, weil das auch für MacOSX gut verfügbar ist und direkt Python nutzt (während PyGame in C geschrieben ist und für jede Platform neu kompiliert werden muss). 
    
    # erstmal ganz grundlegendes: Ein Fenster
    
    fenster = window.Window()
    
    # Dazu brauchen wir ein Schriftelement
    
    schrift = font.load("Arial",  36)
    
    # Und einen Text
    
    zeile = "Hallo Welt!"
    text = font.Text(schrift, zeile)
    
    # Wenn ein Knopf gedrückt wird, soll das Fenster schreien. 
    
    # Dafür brauchen wir ein Ereignis (event) des Fensters
    
    @fenster.event
    def on_key_press(symbol,  modifiers):
        # Wenn allerdings escape gedrückt wird, sagen wir dem Programm, dass es sich in der nächsten Schleife beenden kann. 
        if symbol == 65307: 
            fenster.has_exit = True
        # Erst löschen wir alle Inhalte. 
        fenster.clear()
        # Dann erstellen wir ein neues Text-Element, das die gedrückten Tasten und mod schreit. 
        text = font.Text(schrift,  "Autsch! Symbol: "+ str(symbol) + " Aiiie! Mods: " + str(modifiers))
        # Und zeichnen den Text. 
        text.draw()
        # Schlussendlich aktualisieren wir den Inhalt des Fensters
        fenster.flip()
        # Und warten 0.3 Sekunden, bevor die nächsten Aktionen ausgeführt werden. 
        sleep(0.3)
        # Da wir nun die Funktion verlassen, ändert sich nun auch der Kontext, 
        # und wir haben die alte Variable text wieder. 
    
    # Außerdem brauchen wir eine Schleife, die das Programm in der Ausführung hält. 
    
    # Sie äuft, solange das Fenster nicht meldet, dass es beendet werden soll. 
    
    while not fenster.has_exit: 
        # In ihr werden Ereignisse abgefangen
        fenster.dispatch_events()
        # Das Fenster geleert (was aber erst gezeigt werden wird, sobald es geflippt wird, 
        # so dass die Animation ohne Flackern vonstatten geht)
        fenster.clear()
        # Der Text gezeichnet
        text.draw()
        # Und dann das Fenster aktualisiert. 
        fenster.flip()
        # Diese Art des aktualisierens nennt sich übrigens "double buffered". 
    
    # Voila, wir begrüßen die Welt. 

class SwarmBlob():
    def __init__(self,  x=0,  y=0): 
        self.pos_x = x
        self.pos_y = y
        self.image = image.load(path.join("images", "ball-ally.png" ))
    
def blob_swarm():
    
    # erstmal ganz grundlegendes: Ein Fenster
    
    fenster = window.Window()
    
    # Dazu brauchen wir ein paar Blobs mit Bildern
    
    blobs = [] #: Die Liste der Blobs
    for i in range(10): 
        blob = SwarmBlob()
        blob.pos_x =randint(0,  fenster.width)
        blob.pos_y = randint(0,  fenster.height)
        blobs.append(blob)
    
    def swarm_about(blobs):
        # zufällige Annäherung an andere. 
        MIN_DISTANCE = 2 #: Mindestabstand um sich anzunähern -1. 
        SCALE_MOVEMENT = float(randint(1,  40)) #: Um wieviel die Bewegung verringert wird. 
        for i in blobs: 
            for j in blobs: 
                # Wenn sich zwei berühren, springen sie in eine zufällige Richtung Ort weg. 
                if i.pos_x == j.pos_x and i is not j: 
                    i.pos_x += fenster.width / 4 - randint(0,  fenster.width / 2) 
                    # Wieder in's Fenster zurück schieben. 
                    if i.pos_x < 0 or i.pos_x > fenster.width: 
                        i.pos_x = randint(0,  fenster.width ) 
                if i.pos_y == j.pos_y and i is not j: 
                    i.pos_y += fenster.height / 4 - randint(0,  fenster.height / 2) 
                    # Wieder in's Fenster zurück schieben. 
                    if i.pos_y < 0 or i.pos_y > fenster.height: 
                        i.pos_y = randint(0,  fenster.height ) 
                
                # Ansonsten nähern sie sich langsam an. 
                if i.pos_x < j.pos_x - MIN_DISTANCE: 
                    i.pos_x += randint(0,  int((j.pos_x - i.pos_x) )) / SCALE_MOVEMENT
                elif i.pos_x > j.pos_x +MIN_DISTANCE: 
                    i.pos_x -= randint(0,  int((i.pos_x - j.pos_x))) / SCALE_MOVEMENT
                if i.pos_y < j.pos_y - MIN_DISTANCE: 
                    i.pos_y += randint(0,  int((j.pos_y - i.pos_y) )) / SCALE_MOVEMENT
                elif i.pos_y > j.pos_y +MIN_DISTANCE:  
                    i.pos_y -= randint(0, int((i.pos_y - j.pos_y))) / SCALE_MOVEMENT
    
    # Außerdem brauchen wir eine Schleife, die das Programm in der Ausführung hält. 
    
    # Sie läuft, solange das Fenster nicht meldet, dass es beendet werden soll. 
    
    while not fenster.has_exit: 
        # In ihr werden Ereignisse abgefangen
        fenster.dispatch_events()
        # Das Fenster geleert (was aber erst gezeigt werden wird, sobald es geflippt wird, 
        # so dass die Animation ohne Flackern vonstatten geht)
        fenster.clear()
        # Der Text gezeichnet
        swarm_about(blobs)
        for i in blobs: 
            i.image.blit(i.pos_x,  i.pos_y)
        # Und dann das Fenster aktualisiert. 
        fenster.flip()
        # Und warten 0.03 Sekunden. 
        sleep(0.03)
        
        # Diese Art des aktualisierens nennt sich übrigens "double buffered". 
    
    # Voila, wir begrüßen die Welt. 
    
    
if __name__ == "__main__":
    blob_swarm()
