#!/bin/env python
# encoding: utf-8

# Charakterverwaltung - Verwalte Charaktere im lesbaren YAML Format
# Copyright © 2007 - 2007 Arne Babenhauserheide

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
# MA 02110-1301 USA

"""Manage Charakter-Objects. 

Diese Datei ist ein Container für die klasse Charaktere. 

ToDo: Größere Teile des Charaktersnicht mehr als attribut des OBjekts doppelspeichern, sondern nur durch Funktionen aufrufen. Das dict sollte nur einmal echt geladen werden. Die Eigenschaften des Charakters sollten mit Funktionen aus diesem Hauptdict herausgezogen werden. 
Ausgenommen davon sind Werrte, sie sehr oft gebraucht und geänbdert werden (Geschwindkeit statt Ram-Verbrauch). 
Aktuell wird er Charakter in etwa doppelt geladen. """

### Imports ###

# Für das Dateiformat brauchen wir yaml
import yaml

# Um die Dateien zu laden, nutzen wir die Objekt-Klasse. 
import Skripte.Kernskripte.Objekt as Objekt

# Um Charaktere per Kommandozeile übergeben zu können brauchen wir sys
import sys

# Für die Prüfung ob Charakterdateien schon existieren brauchen wir außerdem os.path
import os

### Imports ###

### Klassen ###

class Charakter: 
    def __init__(self, ID=yaml.load("""ID: tag:draketo.de,2007:Sskreszta
Version: 0.15
Kategorie: Charaktere
"""), art=None): 
    	self.ID = ID
        self.art = art
        self.objekt = Objekt.Objekt(ID=self.ID, template=yaml.load(self.leerer_charakterbogen_yaml()))
        self.charakter = self.objekt.objekt
        self.name = self.name()
        self.grunddaten = self.grunddaten()
        self.beschreibung = self.beschreibung()
        self.werte = self.werte()
        self.eigenschaften = self.eigenschaften()
        self.fertigkeiten = self.fertigkeiten()
        self.kampfwerte = self.kampfwerte()
        self.schutz = self.schutz()
        self.herkunft = self.herkunft()
        self.sprache = self.sprache()
        self.region = self.region()
        self.stimmung = self.stimmung()
        self.kategorie = self.objekt.kategorie()
            
    def name(self): 
        if self.charakter[0][u"Name"] == " ": 
            self.charakter[0][u"Name"] = self.objekt.objekt_name()
            self.objekt.write()
        return self.charakter[0][u"Name"]
        
    def kampfwerte(self): 
    	return self.charakter[4][u"Kampfwerte"]
    def grunddaten(self): 
        return self.charakter[1][u"Grunddaten"]
    def beschreibung(self): 
        return self.grunddaten[u"Beschreibung"]
    def herkunft(self): 
        return self.grunddaten[u"Herkunft"]
    def region(self): 
        return self.herkunft[u"Region"]
    def sprache(self): 
        return self.herkunft[u"Sprache"]
    def stimmung(self): 
        return self.grunddaten[u"Stimmung"]
    def werte(self): 
        return self.charakter[2][u"Werte"]
    def eigenschaften(self): 
        return self.werte[0][u"Eigenschaften"]
    def fertigkeiten(self): 
        return self.werte[1][u"Fertigkeiten"]
    def schutz(self): 
        return self.kampfwerte[u"Hauptrüstung"]["Schutz"]
    
    def leerer_charakterbogen_yaml(self): 
    	return """- Name: " "
- Grunddaten: 
    Beschreibung: " "
    Herkunft: 
        Sprache: ' '
        Region: ' '
    Stimmung: ' '
- Werte:
    - Eigenschaften: " "
    - Fertigkeiten: 
        Nahkampf: &id001
          Zahlenwert: 12
    - Merkmale: " "
- Ausrüstung: 
    Waffen:
      Waffenlos: &id002
        Name: Waffenlos
        Schaden: 1
    Rüestung: 
        Stoffkleidung: &hauptruestung
            Name: Stoffkleidung
            Schutz: 1
- Kampfwerte:  
    Hauptwaffe:
      Kampffertigkeit: *id001
      Waffe: *id002
    Trefferpunkte: 24
    Wundschwelle: 4
    Hauptrüstung: *hauptruestung
"""
    
    

### Klassen ###

### Self-Test ###

if __name__ == '__main__': 
        charakter = Charakter()
        print 'Name:', charakter.name
        print 'Art:', charakter.art
        print '\nID:'
        for i in charakter.ID: 
            print '-', i + ':', charakter.ID[i]
        #print 'Objekt:', charakter.objekt
        #print 'Charakter:', charakter.charakter
        #print 'Grunddaten:', charakter.grunddaten
        #print 'Werte:', charakter.werte
        print '\nEigenschaften:'
        for i in charakter.eigenschaften: 
            print '-', i + ':', charakter.eigenschaften[i]
        print '\nFertigkeiten:'
        for i in charakter.fertigkeiten: 
            print '-', i + ':', charakter.fertigkeiten[i]
        print '\nKampfwerte:'
        for i in charakter.kampfwerte: 
            print '-', i + ':', charakter.kampfwerte[i]
        print '- Schutz:', charakter.schutz
        print '\nBeschreibung:', charakter.beschreibung
        print 'Herkunft:', charakter.herkunft
        print 'Sprache:', charakter.sprache
        print 'Region:', charakter.region
        print 'Stimmung:', charakter.stimmung
        print 'Kategorie:', charakter.kategorie

### Self-Test ###