#!/usr/bin/env python
# encoding: utf-8

# Schlachtfeld - Großkämpfe im EWS System
#   http://rpg-tools-1d6.sf.net
# Copyright © 2007 - 2007 Achim Zien

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
# MA 02110-1301 USA

# This code-file is an example for coding style to use. 

"""The coding style for the Schlachtfeld project. A short overview of the functions and classes in a file should the first line of its docstring, 

It should be tested with epydoc version 3.0 or higher. 

Files which contain at least one class should be structured around imports, constants, classes, functions and self-test. Please look into the coding_style.py file to see an example and descriptions of each part of the file. 

The files should rather contain too many comments than too few. 

This coding style is in RFC mode: Request for comment. Please see it as a beta at best and type comments directly into this file, beginning with a "> " sign. 

Useage: 
In the explanation texts the file should contain general usage instructions like ways to call the class and examples. 

To get the coding style, have a look at the codefile, or let it be processed by epydoc.

Variables and comments should be in english. 
Classes should be written with leading Capital. 

Functions in all lowercase, words seperated by underscores. 

Plans and Ideas: 
Also the first docstring of a file should contain plans and ideas, so that they are all gathered at one central place and can be read out by epydoc. 

This also eases the transition between version management systems (in future) and since epydoc produces nicely laid out websites, it still stays accessible. 

Plans should be included once they are somewhat fixed, ideas should contain a link to a discussion page. 

Once an idea got discussed, its solution should be included as a plan. 

IDEA: 
Maybe plans and ideas could be put into functions which serve only as anchors for docstrings. Maybe they would justify adding a first section in sourcefiles namesn PLANS AND IDEAS. Epydoc will show them as functions, then. 

To differenciate plans and ideas from other functions, they could all start with a common char, for example x like in: 

x_plan_morale_implementation

this way they would also get sorted down in lists and wouldn't interfer with reading otehr functins. 

"""

#### IMPORTS ####

# Any imports should go into this section. 

#### IMPORTS ####


#### CONSTANTS ####

# And global constants need to go here. 

#### CONSTANTS ####


#### CLASSES ####

# All classes of teh files. 

class CodingStyle(): 
    """A docstring describing the class should be included for every class. 
    
    Details for plans with the class and information for adapting it should also go into the docstring.
    
    A docstring should be seperated from the following code by at least one empty line to lessen confusion."""
    
    def __init__(self, style="style"): 
        """Every function needs a docstring, too.
        
        Additional lines should contain special cases and any quirks which might not behave exactly as expected."""
       
        #: The coding style. Every variable needs a description in epydoc format. 
        self.style = style
    
    def __repr__(self): 
        """Information about the class which is intended to be seen by a user of the program, not by a developer. Print it, if it's intended for command line useage, else return it as string. """
        return "coding style. Please see the code-file."
    
#### CLASSES ####


#### FUNCTIONS #### 

# This section contains all kind of funtions which aren't encapsulated into classes. 

#### FUNCTIONS ####


#### SELF-TEST ####

if __name__ == "__main__": 
    # test relevant parts of the file.
    #: An example call of the CodingStyle class. 
    style = CodingStyle()
    # print the coding style. 
    print style

#### SELF-TEST ####
