#!/bin/env python
# -*- coding: utf-8 -*-

# Schlachtfeld - Großk�mpfe im EWS System 
#   http://rpg-tools-1d6.sf.net
# Copyright © 2007 - 2007 Achim Zien

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
# MA 02110-1301 USA


'''
Characters and methods for use in schlachtfeld module.
Characters act on their own now and can be imported and saved via amov module.
'''


#### IMPORTS ####

# for the fighting
from random import randrange as rnd
from random import shuffle
import math

# For selection of armies through command line arguments: 
import sys

# EWS standard dice
from ews import pmw6

# Name-Generator
import namen

# Obtain Charakters from yaml-files
from amov import Charakter, Versionsverwaltung
# replaced the alias with the real directory. 

#### IMPORTS ####




#### Top-Level Objects ####

name_objekt = namen.Name()

# squareroot of maximal one-line-formation
line_cut = 5

# minimum absolute remaining fraction of fighters until resign/flee
powervalue = 0.2

#### Top-Level Objects ####




#### WRAPPERS ####

def ews():
    """Do one roll with the plusminus d6 die (wrapper for a function in pmw6)."""
    return pmw6.pmw6()

def check(skill,MW):
    """Check if a given skill test reached a min-value (wrapper for a function in pmw6)."""
    return pmw6.check(skill,MW)

def ocheck(skill,MW):
    """Return the degree of success / failure for a skill check (wrapper for a function in pmw6)."""
    return pmw6.ocheck(skill,MW)

def name_it(language):
    '''Return a name corresponding to the characters language.'''
    return name_object.erzuege(language)
    
#### WRAPPERS ####




#### CLASSES ####

class Group:
    """
    A group of fighters of mixed types (by now).
    Also contains:
    - situation modifiers
    - commands (resign & flee)
    - a name
    """
    def __init__(self,name=u'unknown group',resign=0.1,flee=0.3,host=None):
        # global group parameters
        self.situation = [12,0,0,0,0] # general, bias, leaders, heroes, other
        self.command = (resign,flee)
        # soldier's rows
        self.active = []
        self.inactive = []
        self.dead = []
        self.fled = []
        # special entities
        self.leader = None
        self.enemy = None
        self.battlefield = None
        self.host = host
        self.name = name
        self.grouptype = "Gruppe"
        # statistics
        self.nact = 0
        self.ninact = 0
        self.n = self.nact + self.ninact
        self.powerratio = 1
        self.aliveratio = 1
        self.empty = True
        self.status = None
        return


    def __repr__(self):
        # nice printout
        scribble = self.name
        scribble += '\nTypus: ' + `self.grouptype`
        scribble += '\nAktiv: ' + `self.nact`
        scribble += '\nInaktiv: ' + `self.ninact`
        scribble += '\nTot, geflohen: ' + `len(self.dead)` + `len(self.fled)`
        return scribble


    def count(self):
        '''
        Count through the lines to establish size of group.
        Battle line length is calculated by approximating group as a recantgle; line_cut is sqrt of max single line formation.
        '''
        self.nact = len(self.active)
        if self.nact > 0:
            self.empty = False
        else:
            self.empty = True
        self.ninact = len(self.inactive)
        self.line = min(self.nact, int(round(line_cut*math.sqrt(self.nact))))
        return self.nact


    def fleeresigncheck(self):
        '''
        Check for retreat or resignation of group.
        Depends on own and opponents powerratio and/or aliveratio + commands given.
        '''
        if self.powerratio < self.command[1] or self.aliveratio < self.command[1] * powervalue:
            self.battlefield.fGroups.append(self.enemy)
            self.status = 'retreated'
        elif self.powerratio < self.command[0] or self.aliveratio < self.command[0] * powervalue:
            self.status = 'resigned'
            self.battlefield.fGroups.append(self.enemy)
        return


    def sethost(self, host):
        '''Set the side of the group, namely the containing army.'''
        self.host = host


    def setenemy(self, enemy):
        '''Convey information about the enemy to a group.'''
        self.enemy = enemy
        return


    def setbattlefield(self, battlefield):
        '''Associate the containing battlefield to the local group for reference purposes.'''
        self.battlefield = battlefield
        return



class Army(Group):
    '''
    One of the sides in the battle.
    Can consist of several Groups and is in itself a Group.
    Army leaders affect all groups.
    '''
    def __init__(self,aname=u'unknown army',aresign=0.1,aflee=0.3):
        Group.__init__(self,name=aname,resign=aresign,flee=aflee)
        self.groups = []
        self.grouptype = "Armee"
        self.host = self
        return


#### CLASSES ####
