#!/gnu/store/pwcp239kjf7lnj5i4lkdzcfcxwcfyk72-bash-minimal-5.0.16/bin/bash
# -*- wisp -*-
GUILE=guile
if ! /gnu/store/6l9rix46ydxyldf74dvpgr60rf5ily0c-guile-3.0.7/bin/guile -L $(dirname $(realpath "$0")) -C $(dirname $(realpath "$0")) --language=wisp -c '' 2>/dev/null; then
    /gnu/store/6l9rix46ydxyldf74dvpgr60rf5ily0c-guile-3.0.7/bin/guile -L $(dirname $(realpath "$0")) -C $(dirname $(realpath "$0")) -c '(import (language wisp spec))' >/dev/null 2>&1
fi
PROG="$0"
if [[ "$1" == "-i" ]]; then
    shift
    exec -a "${PROG}" /gnu/store/6l9rix46ydxyldf74dvpgr60rf5ily0c-guile-3.0.7/bin/guile -L $(dirname $(realpath "$0")) -C $(dirname $(realpath "$0")) --language=wisp -x .w -e '(dryads-wake)' -- "${@}"
else
    exec -a "${PROG}" /gnu/store/6l9rix46ydxyldf74dvpgr60rf5ily0c-guile-3.0.7/bin/guile -L $(dirname $(realpath "$0")) -C $(dirname $(realpath "$0")) --language=wisp -x .w -e '(dryads-wake)' -c '' "${@}" # 2>/dev/null || echo "${PROG} died" >2 && false
fi
; !#

;; for emacs (progn (defun test-this-file () (interactive) (save-current-buffer) (async-shell-command (concat (buffer-file-name (current-buffer)) " --test"))) (local-set-key (kbd "<f9>") 'test-this-file))

define-module : dryads-wake
    . #:export : main
    . #:declarative? #f

import
    only (srfi srfi-19) current-date date->string string->date date->time-utc time-utc->date
                      . make-time time-utc time-duration add-duration current-time
    only (srfi srfi-9) define-record-type
    only (ice-9 pretty-print) pretty-print
    only (ice-9 format) format
    only (srfi srfi-1) first second third alist-cons assoc lset<= lset-intersection lset-difference remove drop
    only (ice-9 ftw) scandir
    enter
    only (d6) roll check
    doctests
    only (names) first-names last-names

define version "0.0.0 just-do-it"

define game-state-initial
    '
      profiles
          juli (player-character) (explain . 9) (fast-talk . 12) (fight . 6)
          dryad (explain . 9) (fast-talk . 9) (fight . 18)
      things ()
      scene . first-encounter
      ;; optionally:
      ;; id . "…"
      ;; name . "…"

;; the game state is an alist, see game-state-initial for an example
define : game-state . states
    if : or (null? states) (null? (car states))
         . game-state-initial
         car states

define : game-state-scene state . states
    . "get the last saved scene. The game should continue from this scene after loading."
    ##
        tests
            test-equal 'first-encounter
                cdr : game-state-scene game-state-initial
    if : null? states
        assoc 'scene : game-state state
        assoc 'scene : car states
define : game-state-scene-set! state scene
    alist-cons 'scene (procedure-name scene) : game-state state

define : game-state-key state key
    . "An arbitrary alist entry in the game state, used to keep decisions and outcomes."
    define value : assoc key : game-state state
    and value
        cdr value
define : game-state-key-set! state key value
    alist-cons key value : game-state state
define : game-state-key-equal? state key value
    . "An arbitrary alist entry in the game state, used to keep decisions and outcomes."
    equal? value : assoc key : game-state state

define : game-state-things state
    . "The set of things you have, equipment and other stuff."
    define things : assoc 'things : game-state state
    and things
        cdr things
define : game-state-things-contains? state thing
    . "#f iff the things do not contain the thing, otherwise not #f"
    member thing : assoc 'things : game-state state
define : game-state-things-add-one! state thing
    . "Add the given thing by its key"
    define things : assoc 'things : game-state state
    set! things : cons thing things
    alist-cons 'things things : game-state state
define : game-state-things-remove-one! state thing
    . "Remove the given thing by its key, returning what was removed or #false"
    define things : assoc 'things : game-state state
    define removed #f
    set! things
        let loop : (out '()) (things things)
            cond
                : null? things
                  reverse! out
                : equal? thing : car things
                  set! removed thing
                  append : reverse! out
                           cdr things
                else
                  loop : cons (car things) out
                         cdr things
    values : alist-cons 'things things : game-state state
           . removed

define : game-state-id state
    . "The identifier for the save-game."
    define id : assoc 'id : game-state state
    and id
        cdr id
define* : game-state-id-set! state id
    alist-cons 'id id : game-state state

define : game-state-name state
    . "The name of the player."
    let : : name : assoc 'name : game-state state
        and name
            cdr name
define : game-state-name-set! state name
    alist-cons 'name name : game-state state

define : name->id name
    . "convert the name into a filesystem-safe representation."
    string-downcase
        string-filter char-set:ascii name

define : game-state-init!
    . "Create a game-state, used when starting a new game."
    set! *random-state*
        random-state-from-platform
    game-state-id-set! : game-state
        name->id
            string-append
                list-ref first-names : random : length first-names
                . "-"
                list-ref last-names : random : length last-names

define %data-folder
    string-join `(,(getenv "HOME") ".local" "share" "dryads-wake") file-name-separator-string
define : save-state state filename
    when : not : file-exists? %data-folder
        mkdir %data-folder
    let : : port : open-output-file : string-join `(,%data-folder ,filename) file-name-separator-string
        write : cons 'game-state-version-0 : game-state state
            . port
        close port
define : load-state filename
    let : : port : open-input-file : string-join `(,%data-folder ,filename) file-name-separator-string
        let : : first-sexp : read port
            cond
                : equal? 'game-state-version-0 : car first-sexp
                  cdr first-sexp
define : game-states
  or
    scandir %data-folder
    list


define-syntax-rule : define-scene (scene-name state) body ...
    . "A scene that saves its state. Loading the game again will start at the last entered scene."
    define : scene-name state
        set! state : game-state-scene-set! state scene-name
        save-state state : game-state-id : game-state state
        define : scene state ;; defining an inner procedure to allow setting properties
            . body ...
        let : : name : procedure-property scene-name 'name
            set-procedure-properties! scene-name : procedure-properties scene
            set-procedure-property! scene-name 'name name
        scene state


;; Game logic helpers
define : profile-ability-score state profile-name ability
    . "Get the ability for the given profile."
    ##
        tests
            test-equal 12
                profile-ability-score '((profiles (juli (explain . 12))))
                    . 'juli 'explain
    cdr : assoc ability : profile-state state profile-name

define : profile-state state profile-name
    . "Get the profile for the PROFILE-NAME."
    ##
        tests
            test-equal '((explain . 12))
                profile-state '((profiles (juli (explain . 12))) (scene . first-encounter)) 'juli
    cdr : assoc profile-name : cdr : assoc 'profiles state

define : score->description score
       . "Give the descriptive label for the given SCORE: ... is <label> at …"
       ##
         tests
           test-equal "good"
             score->description 12
       cond
         {score < 3} "horrible"
         {score < 6} "bad"
         {score < 9} "weak"
         {score < 12} "ok"
         {score < 15} "good"
         {score < 18} "very good"
         {score < 21} "excellent"
         {score < 24} "superb"
         else "legendary"



define : increase-ability-probabilistic state profile ability
    . "Use the cost mechanic of 1d6 without actually tracking costs: if it costs 3 points to increase an ability, increase it with 33% probability."
    define score : profile-ability-score state profile ability
    define cost : max 1 : floor/ {score - 6} 3
    when : = 0 : random cost
        let*
            : profiles : cdr : assoc 'profiles state
              profile-value : cdr : assoc profile profiles
            set! profile-value
                alist-cons ability {score + 1} profile-value
            set! profiles
                alist-cons profile profile-value profiles
            set! state
                alist-cons 'profiles profiles state
            when : assoc 'player-character profile-value
                say-lines : : ,(color 'white) the ,ability score of ,profile increased from ,score to ,(profile-ability-score state profile ability) ,(color #f)
    . state

define : challenge state profile1 profile2 ability threshold
    define score1 : profile-ability-score state profile1 ability
    define score2 : profile-ability-score state profile2 ability
    increase-ability-probabilistic state profile1 ability
    increase-ability-probabilistic state profile2 ability
    check score1 score2 threshold

;; The game story

define : prologue
    Enter : Old One :role narrator

    Old One :eerie
        When the world was young
        lived in the trees
        a dryad from
        the hidden seas.

    Old One
        Then humans came,
        logged for their hold
        the dryad lived on
        dried and cold.

    Old One
        But when new life
        grows in the wood,
        her spirit wakes,
        no longer good.
        The seas are close again.

define : load-game
    define states
        remove : λ (x) : string-prefix? "." x
            game-states
    cond
      : null? states
        Print
            No save games found. Starting new game.
            ,(first-encounter (game-state))
      else
        let 
          : 
            state
              load-state
                list-ref states
                  1-
                    string->number
                        ask
                            map : λ (filename) `(,filename)
                                . states
          let : : scene : game-state-scene state
            if scene
                (module-ref (resolve-module '(dryads-wake)) (cdr scene)) state
                Print
                    No save point found. Starting new game.
                    ,(first-encounter state)


define : read-line
    let loop : : chars '()
        define char : read-char
        if : and (not (null? chars)) (equal? #\newline char)
           apply string : reverse! chars
           loop : cons char chars

define : welcome-menu
    define states
        remove : λ (x) : string-prefix? "." x
            game-states
    if : null? states
        Choose
            : new game
              ,(first-encounter (game-state-init!))
            : show prologue
              ,(prologue) ,(welcome-screen)
            : exit
              We hope you enjoyed our game!
        Choose
            : new game
              ,(first-encounter (game-state-init!))
            : load game
              ,(load-game)
            : show prologue
              ,(prologue) ,(welcome-screen)
            : exit
              We hope you enjoyed our game!


define : title-screen
    Print
        Welcome to
        ""
        ~~~ Dryads Wake ~~~
        ""
        A game of uncertain
        choices & dialogue.


define : welcome-screen
    Enter : Old One :role narrator

    Old One
        I am your companion in this story.
        Where do you want to go?

    welcome-menu


define : first-encounter state
    Enter : Juli Fin :profile juli
            Melter Lark :profile melter
            Rooted Breeze :profile dryad
            Old One

    Print
        Please choose your name
    let : : name : read-line
      map (λ(x) (write-char x (current-error-port))) : string->list name
      set! state : game-state-name-set! state name
    set! state : game-state-id-set! state : name->id : game-state-name state
    set! state : game-state-scene-set! state first-encounter
    save-state state : game-state-id state
    Print
        Welcome ,(string-append (game-state-name state) "!")

    Juli Fin
        Finally we have our own home!

    Melter Lark
        It took long enough.

    Juli Fin
        And it is moist for sure.

    Melter Lark
        I will dry it out.

    Rooted Breeze :eerie
        My slumber breaks
        my mind awakes
        who are you strangers
        in my home?

    Old One
        How do you answer?
        Juli is ,(score->description (profile-ability-score (game-state state) 'juli 'explain))
            . at explaining
        and ,(score->description (profile-ability-score (game-state state) 'juli 'fast-talk))
            . at fast-talk.
    Choose
        : explain your situation to appease the dryad
          ,(explain-your-home state)
        : fast-talk the dryad to get her to leave and risk her anger
          ,(fast-talk-the-dryad state)


define : fast-talk-the-dryad state
    Enter : Juli Fin :profile juli
            Old One :role narrator

    Juli Fin
        We’ve bought this house.
        It will be full of light and heat,
        you’ll be happier in the woods.

    let : : succeeded : challenge state 'juli 'dryad 'fast-talk 3
      cond
        succeeded
           Old One
               ,(color 'green) You succeeded. ,(color #f)
           the-groove-lives state
        else
           Old One
               ,(color 'red) You failed. ,(color #f)
           haunted-house state


define : explain-your-home state
    Enter : Juli Fin :profile juli
            Old One :role narrator

    Juli Fin
        I am Juli. We just got this house.
        We mean you no harm.
        Tell us what you need so we can live together in peace.

    let : : succeeded : challenge state 'juli 'dryad 'explain 3
      cond
        succeeded
           Old One
               ,(color 'green) You managed to convince Rooted Breeze. ,(color #f)
           kindred-house-dryad state
        else
           Old One
               ,(color 'red) You failed to convince Rooted Breeze. You will have to fight. ,(color #f)
           fight-the-dryad state


;; different outcomes of the first confrontation
define : the-groove-lives state
    Enter : Rooted Breeze :profile dryad
    Rooted Breeze
        I will move into the floor,
        bring the plank into the forest
        and I will leave you be.
    set! state : game-state-key-set! state 'dryad 'dryad-left-the-groove-lives
    summer-market state

define : haunted-house state
    Enter : Rooted Breeze :profile dryad
    Rooted Breeze
        No fire will take hold in this house,
        and it is you and your people who will leave!
        ,(color 'white) The dryad disappears to haunt the house. ,(color #f)
    set! state : game-state-key-set! state 'dryad 'angry-dryad-haunts-the-house
    summer-market state

define : kindred-house-dryad state
    Enter : Rooted Breeze :profile dryad
    Rooted Breeze
        I am Rooted Breeze,
        held captive for centuries.
        I need water at my core.
        Build clean water in the back,
        and I will protect your home.
        ,(color 'green) Rooted Breeze becomes your kindred house dryad ,(color #f)
    set! state : game-state-key-set! state 'dryad 'kindred-house-dryad
    summer-market state

define : fight-the-dryad state
    Enter : Rooted Breeze :profile dryad
            Juli Fin :profile juli
            Melter Lark :profile melter
    if : check 6 18 3
        killed-the-dryad state
        dryad-abducted-melter state

define : killed-the-dryad state
    Enter : Rooted Breeze :profile dryad
    Rooted Breeze
        You will suffer for this!
        ,(color 'red) gained dryad essence ,(color #f)
    set! state : game-state-things-add-one! state 'dryad-essence
    set! state : game-state-key-set! state 'dryad 'killed-the-dryad
    summer-market state

define : dryad-abducted-melter state
    Enter : Rooted Breeze :profile dryad
    Rooted Breeze
        You tried to fight and you lost.
        You are mine now, and you will pay!
        ,(color 'red) Takes Melter into the woods
        Melter returns after many weeks,
        but he is changed. ,(color #f)
    set! state : game-state-key-set! state 'dryad 'dryad-abducted-melter
    summer-market state

define-scene : summer-market state
    Enter : Juli Fin :profile juli
            Melter Lark :profile melter
            Old One

    when : game-state-key-equal? state 'dryad 'dryad-abducted-melter
        Old One
            The next day Melter returned,
            strange and absent,
            missing something he had been before.

    Old One
        As a year goes by,
        Juli and Melter get to know the villagers.
        The days seem quiet,
        filled with work.
        ... ,(begin (usleep 300000) #f) ... ,(begin (usleep 600000) #f) ... ,(begin (sleep 1) #f)

    Melter Lark
        Are you ready for the market?

    Juli Fin
        I packed your knives and my poaches.

    Melter Lark
        Remember your spear.

    Juli Fin
        But they welcomed us so nicely,
        and the king is far away.
        What should happen?

    if : game-state-key-equal? state 'dryad 'angry-dryad-haunts-the-house
        Melter Lark
            The dark water spread further.
            Nothing can catch fire anywhere near our house.
            Something is getting stranger.
        Melter Lark
            The wind is too moist,
            my steel spoils at the lightest touch.
            I don’t trust the peace.

    Old One
        The day goes by,
        friends and neighbors join.
        They buy and talk.
        Then a child stumbles and falls,
        and a foreign merchant raises a crossbow.

    second-dryad-the-child state

define-scene : second-dryad-the-child state
    Enter : Becky Waly ;; the merchant
            Geb Namia ;; the child
            Juli Fin
            Melter Lark

    Becky Waly :aims-with-the-crossbow
        Step back. It has to die!
        
    to-be-continued state


define : to-be-continued state
    Enter : Old One
    
    Old One
        You reached the end of the story
        that is already written.
        Please come back with our next release.
    
    Old One
        Load your game to continue in the last scene.
        Thank you for playing!
        ;; FIXME: after loading this is 0
        Your save state is ,(game-state-id (game-state state))
        
        


define : help args
    format : current-output-port
           . "~a [-i] [--help | --version | --test | --server [host]]\n"
           first args

define %this-module : current-module
define : test
  define state : game-state-init!
  doctests-testmod %this-module
  save-state state : game-state-id : game-state state
  ;; load-game
  ;; welcome-menu ;; hack: use to jump directly to the part I’m working on right now. Also setup initial state to test here.

import : only (websocket) run-server websocket-available? make-server-socket
         fibers channels
         fibers internal
         fibers
         ice-9 popen

import : web response

;; replacement for the regular coloring to use span.
define html-colortable
    `
      #f . ""
      black . ""
      blue . "~ "
      yellow . "^ "
      red . "! "
      cyan . "- "
      magenta . "o "
      green . ", "
      white . "/ "

;; TODO: maybe add some compat code to release the fiber in enter? Maybe replace write and read?
define : as-webserver
    . "serve dryads wake over a server port. This REQUIRES guile-websocket installed."
    ;; TODO: Currently this is called on websocket.send()
    define done : make-channel
    define : handler client-socket write-frame make-text-frame input-channel
        define stdout : current-output-port
        define ready-channel : make-channel
        ;; hack to rewire stdin and stdout with a websocket and fibers (must avoid soft ports)
        define in-socket : socketpair PF_UNIX SOCK_STREAM 0
        define out-socket : socketpair PF_UNIX SOCK_STREAM 0
        map : λ (socket) (fcntl socket F_SETFL (logior O_NONBLOCK (fcntl socket F_GETFL)))
            list (car in-socket) (cdr in-socket) (car out-socket) (cdr out-socket)
        spawn-fiber
          λ ()
            with-input-from-port : car in-socket
              λ ()
                with-output-to-port : car out-socket
                  λ ()
                    ;; wait until the websocket is connected
                    ;; wait for fiber 2 and 3 to be ready
                    get-message ready-channel
                    get-message ready-channel
                    catch #t
                      λ :
                        title-screen
                        welcome-screen
                      λ : . args
                        . #f
                    put-message done #t
          . #:parallel? #t
        ;; put data from the websocket into the input
        spawn-fiber
          λ ()
              ;; ignore the first message. It simply enables waiting for the websocket to be ready
              get-message input-channel
              put-message ready-channel #t
              while #t
                  let : : message : get-message input-channel
                      ;; yield-current-fiber
                      
                      ;; write-frame : make-text-frame message
                      ;;   . client-socket
                      map (λ (x) (write-char x (cdr in-socket)))
                          string->list message
                      sleep 0.01
          . #:parallel? #t
        ;; provide all data from socketpair as output via the websocket
        spawn-fiber
          λ ()
            let : : sock : cdr out-socket
              put-message ready-channel #t
              while #t
                let : : char  : read-char sock
                  ;; FIXME: sometimes this gets stuck after the first character even though further characters are put in
                  when
                    not
                      write-frame : make-text-frame : string char
                                  . client-socket
                    close sock
                    break
            . #:parallel? #t
        ;; wait for completion
        get-message done
    module-set! (resolve-module '(enter)) 'colortable html-colortable
    if : websocket-available?
        run-server handler
            make-server-socket #:port 9423 #:addr INADDR_ANY
        . #f

define : final-action? args
   if {(length args) > 1}
     cond
       : equal? "--help" : second args
         help args
         . #t
       : equal? "--version" : second args
         format : current-output-port
                . "~a\n" version
         . #t
       : equal? "--test" : second args
         test
         . #t
       : member (second args) '("--servertest" "--server")
         as-webserver
         . #t
       : equal? "--scene" : second args
         game-state-init!
         apply
           module-ref (resolve-module '(dryads-wake))
             string->symbol : third args
           drop args 3
         . #t
       else #f
     . #f


define : main args
    define states
        remove : λ (x) : string-prefix? "." x
            game-states
    when : not : final-action? args
         title-screen
         when : null? states
             prologue
         welcome-screen
