
;; Added by Package.el.  This must come before configurations of
;; installed packages.  Don't delete this line.  If you don't want it,
;; just comment it out by adding a semicolon to the start of the line.
;; You may delete these explanatory comments.n
(package-initialize)

(custom-set-variables
 ;; custom-set-variables was added by Custom.
 ;; If you edit it by hand, you could mess it up, so be careful.
 ;; Your init file should contain only one such instance.
 ;; If there is more than one, they won't work right.
 '(ido-everywhere t)
 '(ido-mode (quote both) nil (ido))
 '(inhibit-startup-screen t)
 '(org-enforce-todo-dependencies t)
 '(org-time-stamp-custom-formats (quote ("<%Y-%m-%d %a>" . "<%Y-%m-%d %a %H:%M>")))
 '(safe-local-variable-values
   (quote
    ((org-emphasis-alist
      ("*" bold)
      ("/" italic)
      ("_" underline)
      ("=" org-verbatim verbatim)
      ("~" org-code verbatim)
      ("+"
       (:strike-through nil)))
     (org-emphasis-alist
      ("*" bold)
      ("/" italic)
      ("_" underline)
      ("=" org-verbatim verbatim)
      ("~" org-code verbatim))
     (org-babel-noweb-wrap-end . "}}}")
     (org-babel-noweb-wrap-start . "{{{")
     (org-latex-image-default-width . "1.0\\textwidth")
     (org-export-allow-bind-keywords . t)
     (org-confirm-babel-evaluate)
     (org-ditaa-jar-path . "contrib_scripts_ditaa.jar")
     (org-agenda-files "~/ews.org")
     (org-babel-noweb-error-langs "python"
				  (\, "python3"))
     (py-which-shell . "python3")
     (*org-babel-use-quick-and-dirty-noweb-expansion* . t))))
 '(user-full-name "1w6 Team"))
(custom-set-faces
 ;; custom-set-faces was added by Custom.
 ;; If you edit it by hand, you could mess it up, so be careful.
 ;; Your init file should contain only one such instance.
 ;; If there is more than one, they won't work right.
 )

(require 'package)
(require 'ox-html)
(require 'ox-latex)
;; provide the <k template for a kasten (box)
(add-to-list 'org-structure-template-alist '("k" "#+begin_kasten\n?\n#+end_kasten" "<div class=\"kasten\">?</div>"))
;; Org-mode keys
(global-set-key "\C-cl" 'org-store-link)
(global-set-key "\C-ca" 'org-agenda)
(require 'vc)

(add-to-list 'load-path "~/.emacs.d")
(require 'key-chord)

(defun setup-delayed ()
  (require 'babcore)
  (global-auto-complete-mode)
  (global-font-lock-mode))
(add-hook 'after-init-hook 'setup-delayed)
