;; disable experimental JIT-compilation of Emacs via guix install emacs-native-comp, because it requires a writable cache
(setq package-native-compile nil)
(setq comp-deferred-compilation nil)
;; add /tmp to the eln load path to make distcheck work
(when (listp 'native-comp-eln-load-path)
 (add-to-list 'native-comp-eln-load-path (make-temp-file "eln-cache-" t)))

;; Added by Package.el.  This must come before configurations of
;; installed packages.  Don't delete this line.  If you don't want it,
;; just comment it out by adding a semicolon to the start of the line.
;; You may delete these explanatory comments.n
(require 'package)
(when (version< emacs-version "27.0") (package-initialize))
(add-to-list 'package-archives '("melpa" . "https://melpa.org/packages/"))

(custom-set-variables
 ;; custom-set-variables was added by Custom.
 ;; If you edit it by hand, you could mess it up, so be careful.
 ;; Your init file should contain only one such instance.
 ;; If there is more than one, they won't work right.
 '(geiser-default-implementation 'guile)
 '(inhibit-startup-screen t)
 '(org-babel-load-languages '((emacs-lisp . t) (scheme . t)))
 '(org-enforce-todo-dependencies t)
 '(org-time-stamp-custom-formats '("<%Y-%m-%d %a>" . "<%Y-%m-%d %a %H:%M>"))
 '(package-selected-packages
   '(ansi-color saveplace fic-mode use-package-chords goto-last-change use-package legalese goto-chg flymake-cursor fic-ext-mode cups control-lock auto-complete))
 '(safe-local-variable-values
   '((org-confirm-babel-evaluate)
     (org-emphasis-alist
      ("*" bold)
      ("/" italic)
      ("_" underline)
      ("=" org-verbatim verbatim)
      ("~" org-code verbatim)
      ("+"
       (:strike-through nil)))
     (org-emphasis-alist
      ("*" bold)
      ("/" italic)
      ("_" underline)
      ("=" org-verbatim verbatim)
      ("~" org-code verbatim))
     (org-babel-noweb-wrap-end . "}}}")
     (org-babel-noweb-wrap-start . "{{{")
     (org-latex-image-default-width . "1.0\\textwidth")
     (org-export-allow-bind-keywords . t)
     (org-confirm-babel-evaluate nil)
     (org-ditaa-jar-path . "contrib_scripts_ditaa.jar")
     (org-agenda-files "~/ews.org")
     (org-babel-noweb-error-langs "python"
				  (\, "python3"))
     (py-which-shell . "python3")
     (*org-babel-use-quick-and-dirty-noweb-expansion* . t)))
 '(savehist-mode nil)
 '(user-full-name "1w6 Team"))
(custom-set-faces
 ;; custom-set-faces was added by Custom.
 ;; If you edit it by hand, you could mess it up, so be careful.
 ;; Your init file should contain only one such instance.
 ;; If there is more than one, they won't work right.
 )

(require 'package)
(require 'ox-html)
(require 'ox-latex)
;; allow 10 newlines in org-mode italics
(setf (nth 4 org-emphasis-regexp-components) 10)
(load-library "org")
;; provide the <k template for a kasten (box)
(add-to-list 'org-structure-template-alist '("k" "#+begin_kasten\n?\n#+end_kasten" "<div class=\"kasten\">?</div>"))
;; Org-mode keys
(global-set-key "\C-cl" 'org-store-link)
(global-set-key "\C-ca" 'org-agenda)
(require 'vc)

(add-to-list 'load-path "~/.emacs.d/lisp")
(require 'key-chord)

(defun setup-delayed ()
  (require 'babcore)
  (global-auto-complete-mode)
  (global-font-lock-mode))
(add-hook 'after-init-hook 'setup-delayed)


;; Tool: Sort comma-separated wordlists alphabetically
(defun sort-wordlist (beg end arg)
  "Sort a list of words separated by \", \" alphabetically in the region from BEG to END."
  (interactive "r\np")
  (let* ((sep (if (= 0 arg) ", "
                (read-from-minibuffer "Word Separator: " nil nil nil nil ", ")))
         (original (buffer-substring beg end))
         (sorted
          (with-temp-buffer
            (insert original)
            (replace-string sep "\n" nil (point-min) (point-max))
            (sort-lines nil (point-min) (point-max))
            (goto-char (point-min))
            (replace-string  "\n" sep nil (point-min) (point-max))
            (buffer-substring (point-min) (point-max)))))
    (replace-string original sorted nil beg end)))
